package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.RequerimientoOS3;
import com.ejie.ab04b.model.TareaOS3;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0448s00DaoImpl generated by UDA, 31-may-2017 9:30:50.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class RequerimientoOS3DaoImpl implements RequerimientoOS3Dao {

	private static final String QUERY_SELECT = "SELECT t1.ID_TAREA_048 IDTAREA048, t1.MOTIVO_048 MOTIVO048, t1.DESC_OTROS_ES_048 DESCOTROSES048, t1.DESC_OTROS_EU_048 DESCOTROSEU048 FROM AB0448S00 t1 ";

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<RequerimientoOS3> rwMap = new RowMapper<RequerimientoOS3>() {
		public RequerimientoOS3 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new RequerimientoOS3(new TareaOS3(
					resultSet.getLong("IDTAREA048")),
					resultSet.getString("MOTIVO048"),
					resultSet.getString("DESCOTROSES048"),
					resultSet.getString("DESCOTROSEU048"));
		}
	};

	private RowMapper<RequerimientoOS3> rwMapPK = new RowMapper<RequerimientoOS3>() {
		public RequerimientoOS3 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new RequerimientoOS3(new TareaOS3(
					resultSet.getLong("IDTAREA048")),
					resultSet.getString("MOTIVO048"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 * 
	 * @param dataSource
	 *            the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0448s00 table.
	 * 
	 * ab0448s00 Ab0448s00 Ab0448s00
	 * 
	 * @param ab0448s00
	 *            the ab 0448 s 00
	 * @return the requerimiento OS 3
	 */
	public RequerimientoOS3 add(RequerimientoOS3 ab0448s00) {
		String query = "INSERT INTO AB0448S00 (ID_TAREA_048, MOTIVO_048, DESC_OTROS_ES_048, DESC_OTROS_EU_048) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query,
				ab0448s00.getTareaOS3().getIdTarea096(),
				ab0448s00.getMotivo048(), ab0448s00.getDescOtrosEs048(),
				ab0448s00.getDescOtrosEu048());
		return ab0448s00;
	}

	/**
	 * Updates a single row in the Ab0448s00 table.
	 * 
	 * ab0448s00 Ab0448s00 Ab0448s00
	 * 
	 * @param ab0448s00
	 *            the ab 0448 s 00
	 * @return the requerimiento OS 3
	 */
	public RequerimientoOS3 update(RequerimientoOS3 ab0448s00) {
		String query = "UPDATE AB0448S00 SET DESC_OTROS_ES_048=?, DESC_OTROS_EU_048=? WHERE ID_TAREA_048=? AND MOTIVO_048=?";
		this.jdbcTemplate.update(query, ab0448s00.getDescOtrosEs048(),
				ab0448s00.getDescOtrosEu048(), ab0448s00.getTareaOS3()
						.getIdTarea096(), ab0448s00.getMotivo048());
		return ab0448s00;
	}

	/**
	 * Finds a single row in the Ab0448s00 table.
	 * 
	 * ab0448s00 Ab0448s00 Ab0448s00
	 * 
	 * @param ab0448s00
	 *            the ab 0448 s 00
	 * @return the requerimiento OS 3
	 */
	@Transactional(readOnly = true)
	public RequerimientoOS3 find(RequerimientoOS3 ab0448s00) {

		StringBuilder query = new StringBuilder(
				RequerimientoOS3DaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_TAREA_048 = ?   AND t1.MOTIVO_048 = ? ");

		List<RequerimientoOS3> ab0448s00List = this.jdbcTemplate.query(query
				.toString(), this.rwMap, ab0448s00.getTareaOS3()
				.getIdTarea096(), ab0448s00.getMotivo048());

		return (RequerimientoOS3) DataAccessUtils.uniqueResult(ab0448s00List);
	}

	/**
	 * Removes a single row in the Ab0448s00 table.
	 * 
	 * ab0448s00 Ab0448s00
	 * 
	 * @param ab0448s00
	 *            the ab 0448 s 00
	 */
	public void remove(RequerimientoOS3 ab0448s00) {
		String query = "DELETE FROM AB0448S00 WHERE ID_TAREA_048=? AND MOTIVO_048=?";
		this.jdbcTemplate.update(query,
				ab0448s00.getTareaOS3().getIdTarea096(),
				ab0448s00.getMotivo048());
	}

	/**
	 * removePorTarea
	 * 
	 * @param idTarea
	 *            Long
	 */
	@Override
	public void removePorTarea(Long idTarea) {
		String query = "DELETE FROM AB0448S00 WHERE ID_TAREA_048=?";
		this.jdbcTemplate.update(query, idTarea);
	}

	/**
	 * Finds a list of rows in the Ab0448s00 table.
	 * 
	 * ab0448s00 Ab0448s00 jqGridRequestDto JQGridRequestDto List<Ab0448s00>
	 * 
	 * @param ab0448s00
	 *            the ab 0448 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<RequerimientoOS3> findAll(RequerimientoOS3 ab0448s00,
			JQGridRequestDto jqGridRequestDto) {

		StringBuilder query = new StringBuilder(
				RequerimientoOS3DaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0448s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<RequerimientoOS3>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab0448s00 table using like.
	 * 
	 * ab0448s00 Ab0448s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<Ab0448s00>
	 * 
	 * @param ab0448s00
	 *            the ab 0448 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<RequerimientoOS3> findAllLike(RequerimientoOS3 ab0448s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {

		StringBuilder query = new StringBuilder(
				RequerimientoOS3DaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0448s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<RequerimientoOS3>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0448s00 table.
	 * 
	 * ab0448s00 Ab0448s00 Long
	 * 
	 * @param ab0448s00
	 *            the ab 0448 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(RequerimientoOS3 ab0448s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0448S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0448s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0448s00 table using like.
	 * 
	 * ab0448s00 Ab0448s00 startsWith Boolean Long
	 * 
	 * @param ab0448s00
	 *            the ab 0448 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(RequerimientoOS3 ab0448s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0448S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0448s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0448s00 selected for rup_table.
	 * 
	 * ab0448s00 Ab0448s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<TableRowDto<Ab0448s00>>
	 * 
	 * @param ab0448s00
	 *            the ab 0448 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<RequerimientoOS3>> reorderSelection(
			RequerimientoOS3 ab0448s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		StringBuilder query = new StringBuilder(
				RequerimientoOS3DaoImpl.QUERY_SELECT);
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0448s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, RequerimientoOS3.class,
				filterParamList, "ID_TAREA_048,MOTIVO_048");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<RequerimientoOS3>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 * filterParams Ab0448s00 searchParams Ab0448s00 jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<Ab0448s00>>
	 * 
	 * @param filterParams
	 *            the filter params
	 * @param searchParams
	 *            the search params
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<RequerimientoOS3>> search(
			RequerimientoOS3 filterParams, RequerimientoOS3 searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {

		StringBuilder query = new StringBuilder(
				RequerimientoOS3DaoImpl.QUERY_SELECT);
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings(value = "unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, RequerimientoOS3.class,
				filterParamList, searchSQL, searchParamList, from_alias,
				"ID_TAREA_048,MOTIVO_048");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<RequerimientoOS3>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 * filterab0448s00 Ab0448s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean
	 * 
	 * @param filterab0448s00
	 *            the filterab 0448 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 */
	@Override
	public void removeMultiple(RequerimientoOS3 filterab0448s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_TAREA_048 IDTAREA048,t1.MOTIVO_048 MOTIVO048,t1.DESC_OTROS_048 DESCOTROS048 ");
		// FROM
		query.append("FROM AB0448S00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab0448s00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto,
						RequerimientoOS3.class, query, params,
						"ID_TAREA_048,MOTIVO_048");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0448s00 entity.
	 * 
	 * ab0448s00 Ab0448s00 Bean with the criteria values to filter by. Map
	 * created with two keys key query stores the sql query syntax key params
	 * stores the parameter values to be used in the condition sentence.
	 * 
	 * @param ab0448s00
	 *            the ab 0448 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(RequerimientoOS3 ab0448s00) {

		StringBuilder where = new StringBuilder(
				RequerimientoOS3DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0448s00 != null && ab0448s00.getTareaOS3() != null
				&& ab0448s00.getTareaOS3().getIdTarea096() != null) {
			where.append(" AND t1.ID_TAREA_048 = ?");
			params.add(ab0448s00.getTareaOS3().getIdTarea096());
		}
		if (ab0448s00 != null && ab0448s00.getMotivo048() != null) {
			where.append(" AND t1.MOTIVO_048 = ?");
			params.add(ab0448s00.getMotivo048());
		}
		if (ab0448s00 != null && ab0448s00.getDescOtrosEs048() != null) {
			where.append(" AND t1.DESC_OTROS_ES_048 = ?");
			params.add(ab0448s00.getDescOtrosEs048());
		}
		if (ab0448s00 != null && ab0448s00.getDescOtrosEu048() != null) {
			where.append(" AND t1.DESC_OTROS_EU_048 = ?");
			params.add(ab0448s00.getDescOtrosEu048());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0448s00 entity.
	 * 
	 * ab0448s00 Ab0448s00 Bean with the criteria values to filter by.
	 * startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 * 
	 * @param ab0448s00
	 *            the ab 0448 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(RequerimientoOS3 ab0448s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				RequerimientoOS3DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0448s00 != null && ab0448s00.getTareaOS3() != null
				&& ab0448s00.getTareaOS3().getIdTarea096() != null) {
			where.append(" AND t1.ID_TAREA_048 = ?");
			params.add(ab0448s00.getTareaOS3().getIdTarea096());
		}
		if (ab0448s00 != null && ab0448s00.getMotivo048() != null) {
			where.append(" AND UPPER(t1.MOTIVO_048) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0448s00.getMotivo048().toUpperCase() + "%");
			} else {
				params.add("%" + ab0448s00.getMotivo048().toUpperCase() + "%");
			}
			where.append(" AND t1.MOTIVO_048 IS NOT NULL");
		}
		if (ab0448s00 != null && ab0448s00.getDescOtrosEs048() != null) {
			where.append(" AND UPPER(t1.DESC_OTROS_ES_048) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0448s00.getDescOtrosEs048().toUpperCase() + "%");
			} else {
				params.add("%" + ab0448s00.getDescOtrosEs048().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESC_OTROS_ES_048 IS NOT NULL");
		}
		if (ab0448s00 != null && ab0448s00.getDescOtrosEu048() != null) {
			where.append(" AND UPPER(t1.DESC_OTROS_EU_048) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0448s00.getDescOtrosEu048().toUpperCase() + "%");
			} else {
				params.add("%" + ab0448s00.getDescOtrosEu048().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESC_OTROS_EU_048 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

}
